
function get_form_values()
{
	var formdata = new Array();
	var input_name;

	for (var i=0; i <= document.forms.cemainform.length-1; i++)
	{
		input_name = document.forms.cemainform[i].name;
		formdata[input_name] = document.forms.cemainform[i];
	}

	return formdata;
}

function set_default_form_values()
{
	var input_name;

	for (var i=0; i <= document.forms.cemainform.length-1; i++)
	{
		input_name = document.forms.cemainform[i].name;

		if (form_default_values_array[input_name] !== undefined)
		{
			document.forms.cemainform[i].value = form_default_values_array[input_name];
		}
		else if (input_name.search(/_force$/) != -1)
		{
			document.forms.cemainform[i].value = 0;
		}
	}
}

function input_error(name, error)
{
	alert("Error: Invalid input!\nForm field: " + name + "\n\n" + error);
	document.forms.cemainform[name].focus();
	document.forms.cemainform[name].select();
}

function update_graphic(sheet_id,which_g)
{
	if (sheet_id >= 0)
	{
		document.images[which_g].src = "./Character%20Graphics/G" + sheet_id + ".bmp";
	}
	else
	{
		document.images[which_g].src = "./Character%20Graphics/G1.bmp";

	}
}

function help(array_index)
{
	var helpwindow = window.open('', 'helpwindow', 'width=500,height=250,resize=yes,toolbar=no,status=no,directories=no,scrollbars=yes,left=100,right=100');
	
	helpwindow.document.write('<div style="font-family: verdana; font-size: 12px;">' + help_array[array_index] + '</div>');
}

function Trim(s) // Trim function is by Brad Herder (www.vermontsoftware.com)
{
  // Remove leading spaces and carriage returns

  while ((s.substring(0,1) == ' ') || (s.substring(0,1) == '\n') || (s.substring(0,1) == '\r'))
  {
    s = s.substring(1,s.length);
  }

  // Remove trailing spaces and carriage returns

  while ((s.substring(s.length-1,s.length) == ' ') || (s.substring(s.length-1,s.length) == '\n') || (s.substring(s.length-1,s.length) == '\r'))
  {
    s = s.substring(0,s.length-1);
  }
  return s;
}


function generate_code()
{
	window.status = 'Generating...';
	var formdata = get_form_values();
	var cr_code = '';
	//var numbers_only_regexp = new RegExp (/^\d+$/)
	
// Start checking input

// Creature number
	if (formdata['cr_number'].value == '')
	{
		input_error('cr_number', 'You must enter creature\'s number!')
		return;
	}
	else if (isNaN(formdata['cr_number'].value))
	{
		input_error('cr_number', 'Numbers only, please.');
		return;
	}
	else
	{
		cr_code += 'begindefinecreature ' + formdata['cr_number'].value + ";\n";
	}


// Clear
	if (formdata['clear'].value == '0')
	{
		// ok, no clear;
	}
	else
	{
		cr_code += "\t" + 'clear' + ";\n";
	}


// Import
	if (formdata['import'].value == '' || formdata['import'].value == '-1')
	{
		// ok, no import
	}
	else if (isNaN(formdata['import'].value))
	{
		input_error('import', 'Numbers only, please.');
		return;
	}
	else
	{
		cr_code += "\t" + 'import = ' + formdata['import'].value + ";\n";
	}

// Name
	if (formdata['import'].value > 0 && formdata['cr_name'].value == '')
	{
		// ok, name is imported
	}
	else if (formdata['cr_name'].value == '')
	{
		input_error('cr_name', 'You must give the creature a name!');
		return;
	}
	else
	{
		cr_code += "\t" + "cr_name = \"" + formdata['cr_name'].value + "\";\n";
	}
	
	
// Default script
	if ((formdata['cr_default_script'].value == '' || formdata['cr_default_script'].value == 'basicnpc') && formdata['cr_default_script_force'].value != '1')
	{
		// ok, default default script
	}
	else
	{
		cr_code += "\t" + "cr_default_script = \"" + formdata['cr_default_script'].value + "\";\n";
	}


// Creature level
	if ((formdata['cr_level'].value == '' || formdata['cr_level'].value == '2')  && formdata['cr_level_force'].value != '1')
	{
		// ok, default creature lvl
	}
	else if (isNaN(formdata['cr_level'].value))
	{
		input_error('cr_level', 'Numbers only, please.');
		return;
	}
	else
	{
		cr_code += "\t" + "cr_level = " + formdata['cr_level'].value + ";\n";
	}


// Creature HP Bonus
	if ((formdata['cr_hp_bonus'].value == '' || formdata['cr_hp_bonus'].value == '0') && formdata['cr_hp_bonus_force'].value != '1')
	{
		// ok, no hp bonus
	}
	else if (isNaN(formdata['cr_hp_bonus'].value))
	{
		input_error('cr_hp_bonus', 'Numbers only, please.');
		return;
	}
	else
	{
		cr_code += "\t" + "cr_hp_bonus = " + formdata['cr_hp_bonus'].value + ";\n";
	}


// Creature SP Bonus
	if ((formdata['cr_sp_bonus'].value == '' || formdata['cr_sp_bonus'].value == '0') && formdata['cr_hp_bonus_force'].value != '1')
	{
		// ok, no sp bonus
	}
	else if (isNaN(formdata['cr_sp_bonus'].value))
	{
		input_error('cr_sp_bonus', 'Numbers only, please.');
		return;
	}
	else
	{
		cr_code += "\t" + "cr_sp_bonus = " + formdata['cr_sp_bonus'].value + ";\n";
	}


// Special ability
	if ((formdata['cr_special_abil'].value == '0') && formdata['cr_special_abil_force'].value != '1')
	{
		// ok, no special ability
	}
	else
	{
		cr_code += "\t" + "cr_special_abil = " + formdata['cr_special_abil'].value + "; //" + special_abilities_array[formdata['cr_special_abil'].value] + "\n";
	}


// Default attitude
	if ((formdata['cr_default_attitude'].value == '2') && formdata['cr_default_attitude_force'].value != '1')
	{
		// ok, default default attitude
	}
	else
	{
		cr_code += "\t" + "cr_default_attitude = " + formdata['cr_default_attitude'].value + "; //" + attitudes_array[formdata['cr_default_attitude'].value] + "\n";
	}


// Creature species
	if ((formdata['cr_species'].value == '0') && formdata['cr_species_force'].value != '1')
	{
		// ok, default species
	}
	else
	{
		cr_code += "\t" + "cr_species = " + formdata['cr_species'].value + "; //" + species_array[formdata['cr_species'].value] + "\n";
	}


// Natural armor
	if ((formdata['cr_natural_armor'].value == '' || formdata['cr_natural_armor'].value == '0') && formdata['cr_natural_armor_force'].value != '1')
	{
		// ok, default	 natural armor
	}
	else if (isNaN(formdata['cr_natural_armor'].value))
	{
		input_error('cr_natural_armor', 'Numbers only, please.');
		return;
	}
	else
	{
		cr_code += "\t" + "cr_natural_armor = " + formdata['cr_natural_armor'].value + ";\n";
	}


// Innate attacks
	if ((formdata['cr_attack_1'].value == '0') && formdata['cr_attack_1_force'].value != '1')
	{
		// ok, no innate attack 1
	}
	else if (isNaN(formdata['cr_attack_1'].value))
	{
		input_error('cr_attack_1', 'Numbers only, please.');
		return;
	}
	else
	{
		cr_code += "\t" + "cr_attack_1 = " + formdata['cr_attack_1'].value + ";\n";
		cr_code += "\t" + "cr_attack_1_type = " + formdata['cr_attack_1_type'].value + "; //" + attack_types_array[formdata['cr_attack_1_type'].value] + "\n";
	}

	if ((formdata['cr_attack_2'].value == '0') && formdata['cr_attack_2_force'].value != '1')
	{
		// ok, no innate attack 2 or 3
	}
	else if (isNaN(formdata['cr_attack_2'].value))
	{
		input_error('cr_attack_2', 'Numbers only, please.');
		return;
	}
	else
	{
		cr_code += "\t" + "cr_attack_2 = " + formdata['cr_attack_2'].value + ";\n";
		cr_code += "\t" + "cr_attack_23_type = " + formdata['cr_attack_23_type'].value + "; //" + attack_types_array[formdata['cr_attack_23_type'].value] + "\n";

		if ((formdata['cr_attack_3'].value == '0') && formdata['cr_attack_3_force'].value != '1')
		{
			// ok, no innate attack 3
		}
		else if (isNaN(formdata['cr_attack_3'].value))
		{
			input_error('cr_attack_3', 'Numbers only, please.');
			return;
		}
		else
		{
			cr_code += "\t" + "cr_attack_3 = " + formdata['cr_attack_3'].value + ";\n";
		}
	}


// AP bonus
	if ((formdata['cr_ap_bonus'].value == '0') && formdata['cr_ap_bonus_force'].value != '1')
	{
		// ok, default default strategy
	}
	else
	{
		cr_code += "\t" + "cr_ap_bonus = " + formdata['cr_ap_bonus'].value + ";\n";
	}


// Default strategy
	if ((formdata['cr_default_strategy'].value == '0') && formdata['cr_default_strategy_force'].value != '1')
	{
		// ok, default default strategy
	}
	else
	{
		cr_code += "\t" + "cr_default_strategy = " + formdata['cr_default_strategy'].value + "; //" + default_strategies_array[formdata['cr_default_strategy'].value] + "\n";
	}

// Default agression
	if ((formdata['cr_default_agression'].value == '' || formdata['cr_default_agression'].value == '100') && formdata['cr_default_agression_force'].value != '1')
	{
		// ok, default default agression
	}
	else if (isNaN(formdata['cr_default_agression'].value))
	{
		alert('Numbers only, please.');
		formdata['cr_default_agression'].focus();
		return;
	}
	else
	{
		cr_code += "\t" + "cr_default_agression = " + formdata['cr_default_agression'].value + ";\n";
	}


// Default courage
	if ((formdata['cr_default_courage'].value == '' || formdata['cr_default_courage'].value == '100') && formdata['cr_default_courage_force'].value != '1')
	{
		// ok, default default agression
	}
	else if (isNaN(formdata['cr_default_courage'].value))
	{
		alert('Numbers only, please.');
		formdata['cr_default_courage'].focus();
		return;
	}
	else
	{
		cr_code += "\t" + "cr_default_courage = " + formdata['cr_default_courage'].value + ";\n";
	}


// Creature graphic sheet (lower)
	if ((formdata['custom_graphic_number'].value == '-1' && formdata['cr_which_sheet'].value == '1') && formdata['cr_which_sheet_force'].value != '1')
	{
		// ok, lower graphic sheet is default
	}
	else if (formdata['custom_graphic_number'].value > -1)
	{
		cr_code += "\t" + "cr_which_sheet = " + formdata['custom_graphic_number'].value + ";\n";
	}
	else
	{
		cr_code += "\t" + "cr_which_sheet = " + formdata['cr_which_sheet'].value + ";\n";
	}

// Creature graphic sheet (upper)
	if (formdata['custom_graphic_number_upper'].value > -1)
	{
		cr_code += "\t" + "cr_which_sheet_upper = " + formdata['custom_graphic_number_upper'].value + ";\n";
	}
	else if (formdata['cr_which_sheet_upper'].value != '-1')
	{
		cr_code += "\t" + "cr_which_sheet_upper = " + formdata['cr_which_sheet_upper'].value + ";\n";
	}


// Icon adjust
	if ((formdata['cr_icon_adjust'].value == '' || formdata['cr_icon_adjust'].value == '0') && formdata['cr_icon_adjust_force'].value != '1')
	{
		// ok, default icon adjust
	}
	else if (isNaN(formdata['cr_icon_adjust'].value))
	{
		alert('Numbers only, please.');
		formdata['cr_icon_adjust'].focus();
		return;
	}
	else
	{
		cr_code += "\t" + "cr_icon_adjust = " + formdata['cr_icon_adjust'].value + ";\n";
	}


// Small or large template
	if ((formdata['cr_small_or_large_template'].value == '0') && formdata['cr_small_or_large_template_force'].value != '1')
	{
		// ok, use default
	}
	else
	{
		cr_code += "\t" + "cr_small_or_large_template = " + formdata['cr_small_or_large_template'].value + ";\n";
	}


// Summon class
	if ((formdata['cr_summon_class'].value == '-1' || formdata['cr_summon_class'].value == '') && formdata['cr_summon_class_force'].value != '1')
	{
		// ok, use default
	}
	else if (isNaN(formdata['cr_summon_class'].value))
	{
		alert('Numbers only, please.');
		formdata['cr_summon_class'].focus();
		return;
	}
	else
	{
		cr_code += "\t" + "cr_summon_class = " + formdata['cr_summon_class'].value + ";\n";
	}

// Skill adjustment
	for (var i=0; i < 6; i++)
	{
		if (formdata['cr_what_stat_adjust_' + i].value == '-1' || formdata['cr_amount_stat_adjust_' + i].value == '0' || formdata['cr_amount_stat_adjust_' + i].value == '')
		{
			// ok, this skill isn't adjusted
		}
		else if (isNaN(formdata['cr_amount_stat_adjust_' + i].value))
		{
			alert('Numbers only, please.');
			formdata['cr_amount_stat_adjust_' + i].focus();
			return;
		}
		else
		{
			cr_code += "\t" + "cr_what_stat_adjust " + i + " = " + formdata['cr_what_stat_adjust_' + i].value + "; //" + stats_array[formdata['cr_what_stat_adjust_' + i].value] + "\n";
			cr_code += "\t" + "cr_amount_stat_adjust " + i + " = " + formdata['cr_amount_stat_adjust_' + i].value + ";\n";
		}
	}


// Start items & chance
	for (var i=0; i < 8; i++)
	{
		if (formdata['cr_start_item_' + i].value == '-1' || formdata['cr_start_item_' + i].value == '')
		{
			// ok, this starting item isn't set
		}
		else if (isNaN(formdata['cr_start_item_' + i].value))
		{
			alert('Numbers only, please.');
			formdata['cr_start_item_' + i].focus();
			return;
		}
		else
		{
			cr_code += "\t" + "cr_start_item " + i + " = " + formdata['cr_start_item_' + i].value + ";\n";
			cr_code += "\t" + "cr_start_item_chance " + i + " = " + formdata['cr_start_item_chance_' + i].value + ";\n";
		}
	}


// Creature immunities
	for (var i=0; i < 6; i++)
	{
		if (formdata['cr_immunities_' + i].value == '0' || formdata['cr_immunities_' + i].value == '')
		{
			// ok, this immunity isn't set
		}
		else if (isNaN(formdata['cr_immunities_' + i].value))
		{
			alert('Numbers only, please.');
			formdata['cr_immunities_' + i].focus();
			return;
		}
		else
		{
			cr_code += "\t" + "cr_immunities " + i + " = " + formdata['cr_immunities_' + i].value + "; //" + immunities_array[i] + "\n";
		}
	}

	document.forms.codeform.code.value = Trim(cr_code);
}

function parse_code()
{
	window.status = 'Parsing...';
	var input_name;
	var input_value;
	
	set_default_form_values();

	var code = document.forms.codeform.code.value.replace(/\t/g, ''); // remove tabs

	if (code.search(/begindefinecreature [0-9]+;/) == -1)
	{
		alert("Error!\n\n'begindefinecreature' not found.")
		return;
	}

	code = code.replace(/\/\/(.*)/g, ''); // remove comments
	code = code.replace(/"/g, ""); // remove quotes
	code = Trim(code);
	var code_array = code.split(";");
	
	var code_firstline = code_array[0].split(" ");
	code_firstline[0] = Trim(code_firstline[0])
	code_firstline[1] = Trim(code_firstline[1])



	document.forms.cemainform['cr_number'].value = code_firstline[1];

	code_array.shift(); // remove first line

	for (var i=0; i <= code_array.length-1; i++)
	{
		if (code_array[i].search(/=/) != -1)
		{
			code_array[i] = code_array[i].split('=');
			code_array[i][0] = Trim(code_array[i][0]);
			code_array[i][1] = Trim(code_array[i][1]);
			input_name = code_array[i][0].replace(/ /, '_'); // this is for array variables "cr_start_items 0" -> "cr_start_items_0"
			
			input_value = code_array[i][1];
			
			if (input_name == 'cr_which_sheet' && input_value != '1' && (input_value > 1649 || input_value < 1450 || (input_value > 1453 && input_value < 1500)))
			{
				input_name = 'custom_graphic_number';
			}
			else if (input_name == 'cr_which_sheet_upper' && (input_value > 1649 || input_value < 1450 || (input_value > 1453 && input_value < 1500)))
			{
				input_name = 'custom_graphic_number_upper';
			}
			
			//alert("'" + input_name + "'");
			
			if(input_value == form_default_values_array[input_name] && input_name != 'cr_attack_1_type' && input_name != 'cr_attack_23_type' && code_array[i][0].search(/ /) == -1)
			{
				//alert ("'" + input_name + "_force'");
				document.forms.cemainform[input_name + '_force'].value = '1';
			}

			document.forms.cemainform[input_name].value = input_value;
			//document.forms.cemainform[input_name].focus();
		}
		else if (Trim(code_array[i]) == 'clear')
		{
			document.forms.cemainform['clear'].value = 1;
		}
	}
	update_graphic(document.forms.cemainform.cr_which_sheet.value, 'graphic');
	update_graphic(document.forms.cemainform.cr_which_sheet_upper.value, 'graphic_upper');

}